#!/usr/bin/python
# -*- coding: utf-8 -*-

# BlackBox userspace component for LinuxCNC HAL. (c) Serg Oskin

# Компонент записывает состояние всех HAL компонентов и сигналов в файл blackbox.log или с указанным именем.
# активируется любым из сигналов in0..in7 положительным фронтом, in0-not..in7-not отрицательным фронтом.
# входной сигнал дублируется на соотв. пинах out0..out7-not ПОСЛЕ ЗАПИСИ состояния HAL.
# enable - разрешает работу компонента.

import sys
import traceback
import hal, time
from subprocess import Popen, PIPE

if len(sys.argv) == 2:
    outputfile = sys.argv[1]
else:
    outputfile = "BlackBox.log"

h = hal.component("BlackBox")

h.newpin("enable", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in0", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in1", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in2", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in3", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in4", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in5", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in6", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in7", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in0-not", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in1-not", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in2-not", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in3-not", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in4-not", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in5-not", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in6-not", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in7-not", hal.HAL_BIT, hal.HAL_IN)
h.newpin("out0", hal.HAL_BIT, hal.HAL_OUT)
h.newpin("out1", hal.HAL_BIT, hal.HAL_OUT)
h.newpin("out2", hal.HAL_BIT, hal.HAL_OUT)
h.newpin("out3", hal.HAL_BIT, hal.HAL_OUT)
h.newpin("out4", hal.HAL_BIT, hal.HAL_OUT)
h.newpin("out5", hal.HAL_BIT, hal.HAL_OUT)
h.newpin("out6", hal.HAL_BIT, hal.HAL_OUT)
h.newpin("out7", hal.HAL_BIT, hal.HAL_OUT)
h.newpin("out0-not", hal.HAL_BIT, hal.HAL_OUT)
h.newpin("out1-not", hal.HAL_BIT, hal.HAL_OUT)
h.newpin("out2-not", hal.HAL_BIT, hal.HAL_OUT)
h.newpin("out3-not", hal.HAL_BIT, hal.HAL_OUT)
h.newpin("out4-not", hal.HAL_BIT, hal.HAL_OUT)
h.newpin("out5-not", hal.HAL_BIT, hal.HAL_OUT)
h.newpin("out6-not", hal.HAL_BIT, hal.HAL_OUT)
h.newpin("out7-not", hal.HAL_BIT, hal.HAL_OUT)

pin_in0 = 0
pin_in1 = 0
pin_in2 = 0
pin_in3 = 0
pin_in4 = 0
pin_in5 = 0
pin_in6 = 0
pin_in7 = 0
pin_in0_not = 1
pin_in1_not = 1
pin_in2_not = 1
pin_in3_not = 1
pin_in4_not = 1
pin_in5_not = 1
pin_in6_not = 1
pin_in7_not = 1

initialized = 0
    
try:
    print "BlackBox: Starting Up."

    h.ready()
    time.sleep(2.0)
    
    while 1:
        
        if (h["enable"] == 1):
            action = 0
	    action_pin = ""
            if (initialized == 0):
                pin_in0 = h["in0"]
                pin_in1 = h["in1"]
                pin_in2 = h["in2"]
                pin_in3 = h["in3"]
                pin_in4 = h["in4"]
                pin_in5 = h["in5"]
                pin_in6 = h["in6"]
                pin_in7 = h["in7"]
                pin_in0_not = h["in0-not"]
                pin_in1_not = h["in1-not"]
                pin_in2_not = h["in2-not"]
                pin_in3_not = h["in3-not"]
                pin_in4_not = h["in4-not"]
                pin_in5_not = h["in5-not"]
                pin_in6_not = h["in6-not"]
                pin_in7_not = h["in7-not"]
                initialized = 1
            else:
                if ((pin_in0 == 0) and (h["in0"] == 1)):
                    action = 1
                    action_pin += " in0"
                if ((pin_in1 == 0) and (h["in1"] == 1)):
                    action = 1
                    action_pin += " in1"
                if ((pin_in2 == 0) and (h["in2"] == 1)):
                    action = 1
                    action_pin += " in2"
                if ((pin_in3 == 0) and (h["in3"] == 1)):
                    action = 1
                    action_pin += " in3"
                if ((pin_in4 == 0) and (h["in4"] == 1)):
                    action = 1
                    action_pin += " in4"
                if ((pin_in5 == 0) and (h["in5"] == 1)):
                    action = 1
                    action_pin += " in5"
                if ((pin_in6 == 0) and (h["in6"] == 1)):
                    action = 1
                    action_pin += " in6"
                if ((pin_in7 == 0) and (h["in7"] == 1)):
                    action = 1
                    action_pin += " in7"

                if ((pin_in0_not == 1) and (h["in0-not"] == 0)):
                    action = 1
                    action_pin += " in0-not"
                if ((pin_in1_not == 1) and (h["in1-not"] == 0)):
                    action = 1
                    action_pin += " in1-not"
                if ((pin_in2_not == 1) and (h["in2-not"] == 0)):
                    action = 1
                    action_pin += " in2-not"
                if ((pin_in3_not == 1) and (h["in3-not"] == 0)):
                    action = 1
                    action_pin += " in3-not"
                if ((pin_in4_not == 1) and (h["in4-not"] == 0)):
                    action = 1
                    action_pin += " in4-not"
                if ((pin_in5_not == 1) and (h["in5-not"] == 0)):
                    action = 1
                    action_pin += " in5-not"
                if ((pin_in6_not == 1) and (h["in6-not"] == 0)):
                    action = 1
                    action_pin += " in6-not"
                if ((pin_in7_not == 1) and (h["in7-not"] == 0)):
                    action = 1
                    action_pin += " in7-not"

                if (action == 1):
                    localtime = time.localtime(time.time())
                    hc = Popen('halcmd show', shell=True, stdout=PIPE).stdout.read()
                    try:
                        out = open(outputfile, "a")
                    except IOError:
                        print 'cannot open', outputfile
                    else:
                        out.write("====================================== " + time.asctime() + action_pin + " ======================================\n\n")
                        out.write(hc)
                        out.write("\n")
                        out.close()

            h["out0"] = pin_in0 = h["in0"]
            h["out1"] = pin_in1 = h["in1"]
            h["out2"] = pin_in2 = h["in2"]
            h["out3"] = pin_in3 = h["in3"]
            h["out4"] = pin_in4 = h["in4"]
            h["out5"] = pin_in5 = h["in5"]
            h["out6"] = pin_in6 = h["in6"]
            h["out7"] = pin_in7 = h["in7"]
            h["out0-not"] = pin_in0_not = h["in0-not"]
            h["out1-not"] = pin_in1_not = h["in1-not"]
            h["out2-not"] = pin_in2_not = h["in2-not"]
            h["out3-not"] = pin_in3_not = h["in3-not"]
            h["out4-not"] = pin_in4_not = h["in4-not"]
            h["out5-not"] = pin_in5_not = h["in5-not"]
            h["out6-not"] = pin_in6_not = h["in6-not"]
            h["out7-not"] = pin_in7_not = h["in7-not"]

        else:
            initialized = 0

        time.sleep(0.01)

except KeyboardInterrupt:
    pass

except:
    traceback.print_exc()
    print "BlackBox Shutting down."
    raise SystemExit

