#!/bin/bash
coreNum=$1

function cleanup {
    echo "kill trapped: $pid"
    exit
}

islcnc=$(pgrep -c linuxcncsvr)
if [ $islcnc -gt 0 ]
then
    echo "linuxcncsvr - found"
    if [ ! -e $HOME/.hog.pid ]
    then
        echo "No hog pid found - starting hog on core 2"
        # start hog on core 2
        $HOME/dev/rtlinux/hog.sh 2 &>/dev/null &
    fi
else
    if [ -e $HOME/.hog.pid ]
    then
        echo "No linuxcncsvr BUT hog pid found - stopping hog"
        # get hog pid
        pid=$(cat $HOME/.hog.pid)
        kill $pid
    else
        echo "No action to take"
    fi
fi

