#!/bin/bash
# Orchestration of linuxcnc start sequence for T610
# 1. set cpu hog in place on core 2
# 2. start linuxcnc on core 2
# 3. once linuxcnc all started move the UI back to core 1
# 4. wait for linuxcnc to stop and when stopped kill cpu hog

cmd=$HOME/dev/rtlinux

# 1. set cpu hog in place on core 2
echo "Start cpu hog"
$cmd/hog.sh 2  &>/dev/null &
hog_pid=$!
# 2. start linuxcnc on core 2
echo "Start LinuxCNC"
taskset 0x02 linuxcnc &>$HOME/lcnc-out.txt &
lcnc_pid=$!
# 3. once linuxcnc all started move the UI back to core 1
while [ $(pgrep -c qtpyvcp) -eq 0 ] && [ $(pgrep -c axis) -eq 0 ] && [ $(pgrep -c qtvcp) -eq 0 ]
do
    # waiting for linuxcnc and ui to have fully started
    sleep 1
done
if [ $(pgrep -c qtpyvcp) -gt 0 ]
then
    echo "Move QtPyVCP to core 1"
    $cmd/pyqtvcp-core1.sh &>/dev/null
elif [ $(pgrep -c axis) -gt 0 ]
then
    echo "Move Axis to core 1"
    $cmd/axis-core1.sh &>/dev/null
elif [ $(pgrep -c qtvcp) -gt 0 ]
then
    echo "Move QtVcp to core 1"
    $cmd/qtvcp-core1.sh &>/dev/null
else
    echo "No UI matched to move."
fi
# 4. wait for linuxcnc to stop and when stopped kill cpu hog
echo "Wait for LinuxCNC to end"
wait $lcnc_pid
#echo "Cleanly kill cpu hog"
kill $hog_pid

