#ifndef GET_POSITION_H
#define GET_POSITION_H

#include <emc.hh>
#include <emc_nml.hh>
#include <iostream>
#include <config.h>

struct POS{
    double x=0;
    double y=0;
    double z=0;
};

POS get_position(){
    const char *cstr = nmlfile.c_str();
    POS pos;
    RCS_STAT_CHANNEL *stat = new RCS_STAT_CHANNEL(emcFormat, "emcStatus", "xemc", cstr);

    for(int i=0; i<1; i++){
        usleep(100*1000);
        if(!stat->valid()) continue;
        if(stat->peek() != EMC_STAT_TYPE) continue;
        EMC_STAT *emcStatus = static_cast<EMC_STAT*>(stat->get_address());

        pos.x=emcStatus->motion.traj.position.tran.x;
        pos.y=emcStatus->motion.traj.position.tran.y;
        pos.z=emcStatus->motion.traj.position.tran.z;
    }
    return pos;
}

#endif // GET_POSITION_H
