#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <qfiledialog.h>
#include <qstring.h>
#include <cstdlib>

#include <emc.hh>
#include <emc_nml.hh>
#include <iostream>
#include <get_position.h>
#include <home.h>
#include <estop.h>
#include <estop_reset.h>
#include <state_on.h>
#include <state_off.h>
#include <jog.h>
#include <run_forward.h>
#include <run_backward.h>
#include <pause.h>
#include <resume.h>
#include <step.h>
#include <stop.h>
#include <mode_auto.h>
#include <mode_manual.h>
#include <mode_mdi.h>
#include <mdi.h>
#include <maxvel.h>
#include <spindle_on.h>
#include <spindle_off.h>
#include <config.h>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    timerId = startTimer(200);

     ui->toolButton_estop->setChecked(true);
     estop();
}

void MainWindow::timerEvent(QTimerEvent *)
{
    POS pos=get_position();
    ui->lineEdit_x_pos->setText(QString::number(pos.x,'f',4));
    ui->lineEdit_y_pos->setText(QString::number(pos.y,'f',4));
    ui->lineEdit_z_pos->setText(QString::number(pos.z,'f',4));
}

MainWindow::~MainWindow()
{
    killTimer(timerId);
    delete ui;
}

void MainWindow::on_toolButton_estop_toggled(bool checked)
{
    if(checked){
        estop();
        ui->toolButton_state->setChecked(false);
        state_off();

    } else {
        estop_reset();
    }
}

void MainWindow::on_toolButton_state_toggled(bool checked)
{
    if(checked){
        ui->toolButton_estop->setChecked(false);
        estop_reset();
        state_on();
    } else {
        state_off();
    }
}

void MainWindow::on_pushButton_home_pressed()
{
    home_();
}

void MainWindow::on_pushButton_x_min_pressed()
{
    mode_manual();
    jog(0,-100,0);
}

void MainWindow::on_pushButton_x_min_released()
{
    jog(0,0,0);
}

void MainWindow::on_pushButton_x_plus_pressed()
{
    mode_manual();
    jog(0,100,0);
}

void MainWindow::on_pushButton_x_plus_released()
{
    jog(0,0,0);
}

void MainWindow::on_pushButton_y_plus_pressed()
{
    mode_manual();
    jog(1,100,0);
}

void MainWindow::on_pushButton_y_plus_released()
{
    jog(1,0,0);
}

void MainWindow::on_pushButton_y_min_pressed()
{
    mode_manual();
    jog(1,-100,0);
}

void MainWindow::on_pushButton_y_min_released()
{
    jog(1,0,0);
}

void MainWindow::on_pushButton_z_plus_pressed()
{
    mode_manual();
    jog(2,100,0);
}

void MainWindow::on_pushButton_z_plus_released()
{
    jog(2,0,0);
}

void MainWindow::on_pushButton_z_min_pressed()
{
    mode_manual();
    jog(2,-100,0);
}

void MainWindow::on_pushButton_z_min_released()
{
    jog(2,0,0);
}

void MainWindow::on_pushButton_run_forward_pressed()
{
    mode_auto();
    run_forward(0);
}

void MainWindow::on_pushButton_backward_pressed()
{
    mode_auto();
    run_backward();
}

void MainWindow::on_pushButton_pause_pressed()
{
    pause_();
}

void MainWindow::on_pushButton_resume_pressed()
{
    resume();
}

void MainWindow::on_pushButton_step_pressed()
{
    step();
}

void MainWindow::on_pushButton_stop_pressed()
{
    stop();
}

void MainWindow::on_pushButton_mode_auto_pressed()
{
    mode_auto();
}

void MainWindow::on_pushButton_mode_manual_pressed()
{
    mode_manual();
}

void MainWindow::on_pushButton_mode_mdi_pressed()
{
    mode_mdi();
}

void MainWindow::on_pushButton_mdi_go_pressed()
{
   mdi(ui->lineEdit_mdi->text().toStdString());
}

void MainWindow::on_horizontalSlider_max_velocity_sliderMoved(int position)
{
    maxvel(double(position));
}

void MainWindow::on_pushButton_spindle_ccw_toggled(bool checked)
{

    int rpm_neg = -abs(ui->lineEdit_rpm->text().toInt()); //-abs is negative
    if(checked){
        ui->pushButton_spindle_cw->setChecked(false);
        spindle_on(0,rpm_neg);
    } else {
        spindle_off();
    }
}

void MainWindow::on_pushButton_spindle_cw_toggled(bool checked)
{

    int rpm = abs(ui->lineEdit_rpm->text().toInt()); //abs is positive
    if(checked){
        ui->pushButton_spindle_ccw->setChecked(false);
        spindle_on(0,rpm);
    } else {
        spindle_off();
    }
}































