#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <display/variable.h>
#include <display/opengl.h>
#include <qfiledialog.h>
#include <qstring.h>
#include <cstdlib>

#include <emc.hh>
#include <emc_nml.hh>
#include <iostream>
#include <lcnc/home.h>
#include <lcnc/unhome.h>
#include <lcnc/estop.h>
#include <lcnc/estop_reset.h>
#include <lcnc/state_on.h>
#include <lcnc/state_off.h>
#include <lcnc/jog.h>
#include <lcnc/run_forward.h>
#include <lcnc/run_backward.h>
#include <lcnc/pause.h>
#include <lcnc/resume.h>
#include <lcnc/step.h>
#include <lcnc/stop.h>
#include <lcnc/mode_auto.h>
#include <lcnc/mode_manual.h>
#include <lcnc/mode_mdi.h>
#include <lcnc/mdi.h>
#include <lcnc/maxvel.h>
#include <lcnc/spindle_on.h>
#include <lcnc/spindle_off.h>
#include <lcnc/spindle_stop.h>
#include <lcnc/open_file.h>
#include <lcnc/enable_adaptive_feed.h>
#include <lcnc/feed_override.h>
#include <lcnc/reset_interpreter.h>
#include <hal/halsection.h>

//test
#include <rs274ngc.hh>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    timerId = startTimer(200);

     ui->toolButton_estop->setChecked(true);
     estop();

     hal_connection();
}

void MainWindow::timerEvent(QTimerEvent *)
{
    ui->lineEdit_x_pos->setText(QString::number(toolpos.x,'f',4));
    ui->lineEdit_y_pos->setText(QString::number(toolpos.y,'f',4));
    ui->lineEdit_z_pos->setText(QString::number(toolpos.z,'f',4));
}

MainWindow::~MainWindow()
{
    killTimer(timerId);
    delete ui;
}

void MainWindow::on_toolButton_estop_toggled(bool checked)
{
    if(checked){
        estop();
        ui->toolButton_state->setChecked(false);
        state_off();

    } else {
        estop_reset();
    }
}

void MainWindow::on_toolButton_state_toggled(bool checked)
{
    if(checked){
        ui->toolButton_estop->setChecked(false);
        estop_reset();
        state_on();
    } else {
        state_off();
    }
}

void MainWindow::on_pushButton_home_pressed()
{
    home_();
}

void MainWindow::on_pushButton_x_min_pressed()
{
    mode_manual();
    jog(0,-ui->horizontalSlider_jog_speed->value(),0);
}

void MainWindow::on_pushButton_x_min_released()
{
    jog(0,0,0);
}

void MainWindow::on_pushButton_x_plus_pressed()
{
    mode_manual();
    jog(0,ui->horizontalSlider_jog_speed->value(),0);
}

void MainWindow::on_pushButton_x_plus_released()
{
    jog(0,0,0);
}

void MainWindow::on_pushButton_y_plus_pressed()
{
    mode_manual();
    jog(1,ui->horizontalSlider_jog_speed->value(),0);
}

void MainWindow::on_pushButton_y_plus_released()
{
    jog(1,0,0);
}

void MainWindow::on_pushButton_y_min_pressed()
{
    mode_manual();
    jog(1,-ui->horizontalSlider_jog_speed->value(),0);
}

void MainWindow::on_pushButton_y_min_released()
{
    jog(1,0,0);
}

void MainWindow::on_pushButton_z_plus_pressed()
{
    mode_manual();
    jog(2,ui->horizontalSlider_jog_speed->value(),0);
}

void MainWindow::on_pushButton_z_plus_released()
{
    jog(2,0,0);
}

void MainWindow::on_pushButton_z_min_pressed()
{
    mode_manual();
    jog(2,-ui->horizontalSlider_jog_speed->value(),0);
}

void MainWindow::on_pushButton_z_min_released()
{
    jog(2,0,0);
}

void MainWindow::on_pushButton_run_forward_pressed()
{
    mode_auto();
    run_forward(0);
}

void MainWindow::on_pushButton_backward_pressed()
{
    mode_auto();
    run_backward();
}

void MainWindow::on_pushButton_pause_pressed()
{
    pause_();
}

void MainWindow::on_pushButton_resume_pressed()
{
    resume();
}

void MainWindow::on_pushButton_step_pressed()
{
    step();
}

void MainWindow::on_pushButton_stop_pressed()
{
    stop();
}

void MainWindow::on_pushButton_mode_auto_pressed()
{
    mode_auto();
}

void MainWindow::on_pushButton_mode_manual_pressed()
{
    mode_manual();
}

void MainWindow::on_pushButton_mode_mdi_pressed()
{
    mode_mdi();
}

void MainWindow::on_pushButton_mdi_go_pressed()
{
   mdi(ui->lineEdit_mdi->text().toStdString());
}

void MainWindow::on_pushButton_spindle_ccw_toggled(bool checked)
{
    int rpm_neg = -abs(ui->lineEdit_rpm->text().toInt()); //-abs is negative
    if(checked){
        ui->pushButton_spindle_cw->setChecked(false);
        spindle_on(0,rpm_neg);
    } else {
        spindle_off();
    }
}

void MainWindow::on_pushButton_spindle_cw_toggled(bool checked)
{
    int rpm = abs(ui->lineEdit_rpm->text().toInt()); //abs is positive
    if(checked){
        ui->pushButton_spindle_ccw->setChecked(false);
        spindle_on(0,rpm);
    } else {
        spindle_off();
    }
}

void MainWindow::on_pushButton_spindle_stop_pressed()
{
    spindle_stop();
    ui->pushButton_spindle_cw->setChecked(false);
    ui->pushButton_spindle_ccw->setChecked(false);
}

void MainWindow::on_pushButton_open_file_pressed()
{
    std::string gcode_read_in=open_file();
    ui->textBrowser_gcode->clear();
    ui->textBrowser_gcode->setText(QString::fromStdString(gcode_read_in));
}

void MainWindow::on_pushButton_unhome_pressed()
{
    unhome();
}

void MainWindow::on_pushButton_reset_intepreter_pressed()
{
    reset_interpreter();
}

void MainWindow::on_pushButton_task_plan_read_pressed()
{
    const char *cstr = nmlfile.c_str();
    RCS_CMD_CHANNEL *c = new RCS_CMD_CHANNEL(emcFormat, "emcCommand", "xemc", cstr);

    EMC_TASK_PLAN_READ r;
    c->write(&r);
}

void MainWindow::on_pushButton_clear_toolpath_pressed()
{
    toolpath.clear();
}


void MainWindow::on_horizontalSlider_jog_speed_sliderMoved(int position)
{

}

void MainWindow::on_horizontalSlider_feed_override_sliderMoved(int position)
{
    feed_override(position);
}

void MainWindow::on_checkBox_adaptive_feed_stateChanged(int arg1)
{
    enable_adaptive_feed(arg1);
}

void MainWindow::on_pushButton_halshow_pressed()
{
    system("halshow &");
}

void MainWindow::on_pushButton_hal_signal_test_pressed()
{
    hal_signal_test();
}

void MainWindow::on_pushButton_command_test_pressed()
{
    hal_command_test();
}
