#ifndef GET_POSITION_H
#define GET_POSITION_H

#include <emc.hh>
#include <emc_nml.hh>
#include <iostream>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <display/variable.h>

POINT get_position(){ //function used in display/display.h
    std::string nmlfile="/home/user/linuxcnc/configs/common/linuxcnc.nml";
    const char *cstr = nmlfile.c_str();
    POINT t;
    RCS_STAT_CHANNEL *stat = new RCS_STAT_CHANNEL(emcFormat, "emcStatus", "xemc", cstr);

    for(int i=0; i<1; i++){
        usleep(100);
        if(!stat->valid()) continue;
        if(stat->peek() != EMC_STAT_TYPE) continue;
        EMC_STAT *emcStatus = static_cast<EMC_STAT*>(stat->get_address());

        t.x=emcStatus->motion.traj.position.tran.x;
        t.y=emcStatus->motion.traj.position.tran.y;
        t.z=emcStatus->motion.traj.position.tran.z;

        emcStatus_task_currentLine=emcStatus->task.currentLine;
        emcStatus_task_motionLine=emcStatus->task.motionLine;
        emcStatus_task_mode=emcStatus->task.mode;  //1=manual 2=auto 3=mdi
        emcStatus_motion_status=emcStatus->motion.status; //2=auto running

        //from file emcsh.cc we get the active gcode and mcode, feedrate and spindlespeed values from status channel.
        char string[256];
        int t;
        int code;

        // fill in the active G codes
        task_active_gcodes_string[0] = 0;
        for (t = 1; t < ACTIVE_G_CODES; t++) {
            code = emcStatus->task.activeGCodes[t];
            if (code == -1) {
                continue;
            }
            if (code % 10) {
                sprintf(string, "G%.1f ", (double) code / 10.0);
            } else {
                sprintf(string, "G%d ", code / 10);
            }
            strcat(task_active_gcodes_string, string);
        }

        // fill in the active M codes, settings too
        task_active_mcodes_string[0] = 0;
        for (t = 1; t < ACTIVE_M_CODES; t++) {
            code = emcStatus->task.activeMCodes[t];
            if (code == -1) {
                continue;
            }
            sprintf(string, "M%d ", code);
            strcat(task_active_mcodes_string, string);
        }

        // fill in F and S codes also
        sprintf(string, "F%.0f ", emcStatus->task.activeSettings[1]);
        task_active_fcodes_string[0] = 0;
        strcat(task_active_fcodes_string, string);
        sprintf(string, "S%.0f", fabs(emcStatus->task.activeSettings[2]));
        task_active_scodes_string[0] = 0;
        strcat(task_active_scodes_string, string);



    }
    return t;
}

#endif // GET_POSITION_H






















