#ifndef DISPLAY_H
#define DISPLAY_H
#include <display/variable.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <lcnc/get_position.h>
#include <math.h>

bool trigger=0;
double dist=0;
POINT p={0,0,0};

void display(){

    //show current tool position
    toolpos=get_position();
    glLineWidth(1);
    glColor4d(255,0,0,255);
    glBegin(GL_LINES);
    glVertex3d(-5+toolpos.x,toolpos.y,toolpos.z);
    glVertex3d(5+toolpos.x,toolpos.y,toolpos.z);
    glVertex3d(toolpos.x,5+toolpos.y,toolpos.z);
    glVertex3d(toolpos.x,-5+toolpos.y,toolpos.z);
    glEnd();


    dist=sqrt(pow(toolpos.x-p.x,2)+pow(toolpos.y-p.y,2));
    //std::cout<<"dist: "<<dist<<std::endl;

    //mark toolpath
    if(!trigger){
        p=toolpos;
        trigger=1;
    }

    if(dist>0.01){
        if(toolpath.size()>1000000){
            toolpath.clear();
        }
        toolpath.push_back({toolpos.x,toolpos.y,toolpos.z});
        //std::cout<<"toolpath pushed back"<<std::endl;
        dist=0;
        trigger=0;
    }
    glColor4d(0,255,0,255);
    glBegin(GL_LINE_STRIP);
    for(int i=0; i<toolpath.size(); i++){
         glVertex3d(toolpath.at(i).x,toolpath.at(i).y,toolpath.at(i).x);
    }
    glEnd();

}

#endif // DISPLAY_H
