#!/usr/bin/env python

import hal
from hal_glib import GStat
import gobject
GSTAT = GStat()

# callback to change HAL pin state
def mode_changed(obj, data):
        h['rotation_xy'] = data

# Make a component and pins
h = hal.component("metric_status")
h.newpin("rotation_xy", hal.HAL_BIT, hal.HAL_OUT)
h.ready()

# connect a GSTAT message to a callback function
GSTAT.connect("metric-mode-changed",mode_changed)

# force GSTAT to initialize states
GSTAT.forced_update()

# loop till exit
try:
        gobject.MainLoop().run()
except KeyboardInterrupt:
    raise SystemExit