#!/usr/bin/env python

import hal
from hal_glib import GStat
import gobject
GSTAT = GStat()

# callback to change HAL pin state
# there is and current angle status pin and a
# is-rotated bool pin
def angle_changed(obj, data):
    h['z-rotated-angle'] = data
    if data == 0:
        h['z-is-rotated'] = False
    else:
        h['z-is-rotated'] = True

# Make a component and pins
h = hal.component("z_rotation")
h.newpin("z-rotated-angle", hal.HAL_FLOAT, hal.HAL_OUT)
h.newpin("z-is-rotated", hal.HAL_BIT, hal.HAL_OUT)
h.ready()

# connect a Z rotation message to the callback function
GSTAT.connect("current-z-rotation", angle_changed)

# force GSTAT to initialize states
GSTAT.forced_update()

# loop till exit
try:
        gobject.MainLoop().run()
except KeyboardInterrupt:
    raise SystemExit