# EL2564 Quick Start Guide

## 5-Minute Setup

### Step 1: Install the Driver

```bash
# Copy driver files
sudo cp lcec_el2564.c /usr/src/linuxcnc-ethercat/src/devices/
sudo cp EL2564.yml /usr/src/linuxcnc-ethercat/src/devices/

# Rebuild
cd /usr/src/linuxcnc-ethercat
sudo make clean && sudo make && sudo make install
```

### Step 2: Add to EtherCAT Configuration

Edit your `ethercat-conf.xml`:

```xml
<slave idx="16" type="EL2564" name="EL2564-1"/>
```

(Change `idx` to match your slave position)

### Step 3: Create HAL Configuration

Create `el2564.hal`:

```hal
# Enable all channels
setp lcec.0.EL2564-1.enable-0 1
setp lcec.0.EL2564-1.enable-1 1
setp lcec.0.EL2564-1.enable-2 1
setp lcec.0.EL2564-1.enable-3 1

# Set scale to 1.0 (percentage input)
setp lcec.0.EL2564-1.scale-0 1.0
setp lcec.0.EL2564-1.scale-1 1.0
setp lcec.0.EL2564-1.scale-2 1.0
setp lcec.0.EL2564-1.scale-3 1.0

# Set initial color (green)
setp lcec.0.EL2564-1.pwm-0 0
setp lcec.0.EL2564-1.pwm-1 100
setp lcec.0.EL2564-1.pwm-2 0
setp lcec.0.EL2564-1.pwm-3 0
```

### Step 4: Add to INI File

```ini
[HAL]
HALFILE = el2564.hal
```

### Step 5: Wire the LEDs

```
PSU +24V  ───> Terminal 3 (LED supply+)
PSU GND   ───> Terminal 4 (LED supply-)

LED Strip:
  Anode (+) ───> Terminal 3 (LED supply+)
  Red (-)   <─── Terminal 1
  Green (-) <─── Terminal 5
  Blue (-)  <─── Terminal 2
  White (-) <─── Terminal 6
```

### Step 6: Test

```bash
# Start LinuxCNC
linuxcnc your-config.ini

# Or test with halrun
halrun -f el2564.hal
```

---

## Quick Color Reference

| Color | R | G | B | W |
|-------|---|---|---|---|
| Red | 100 | 0 | 0 | 0 |
| Green | 0 | 100 | 0 | 0 |
| Blue | 0 | 0 | 100 | 0 |
| Yellow | 100 | 100 | 0 | 0 |
| Cyan | 0 | 100 | 100 | 0 |
| Magenta | 100 | 0 | 100 | 0 |
| Orange | 100 | 50 | 0 | 0 |
| White (RGB) | 100 | 100 | 100 | 0 |
| White (W) | 0 | 0 | 0 | 100 |

---

## Demo Files

### Full Demo (All Modes)

Run the complete demo showcasing all features:

```bash
cd /home/cnc/linuxcnc/configs/test_ec_2
halrun -f el2564_full_demo.hal
```

**Includes:**
- 10 predefined colors (Red, Green, Blue, Yellow, Cyan, Magenta, Orange, Pink, Purple, White)
- Brightness levels (10% → 100% → 10%)
- Rainbow color wheel animation
- Breathing effect (5 colors)
- Strobe/Flash effect
- Color fade transitions
- Finale sequence

### Breathing Demo

Run the breathing-only demo:

```bash
halrun -f el2564_breathing_demo.hal
```

**Features:**
- 10 brightness steps (0-100% in 10% increments)
- Smooth 80ms transitions between steps
- Colors: Red, Green, Blue, Cyan, Magenta, White
- 2 cycles per color

**Custom Breathing Pattern:**

```hal
# Single step example (Red breathing)
setp lcec.0.EL2564-1.pwm-0 0
loadusr -w sleep 0.08
setp lcec.0.EL2564-1.pwm-0 10
loadusr -w sleep 0.08
setp lcec.0.EL2564-1.pwm-0 20
# ... continue to 100%, then back to 0
```

---

## Common Issues

**LEDs not working?**
1. Check slave is in OP state: `ethercat slaves`
2. Check enable pins are set: `halcmd show pin | grep enable`
3. Check LED power supply is connected

**Flickering?**
```bash
# Before starting LinuxCNC:
ethercat download -p <pos> 0xf819 0x11 -t uint32 15000
```

**Warning bits TRUE?**
- Normal when no LEDs connected (open load detection)
