#!/usr/bin/env python3

# -*- coding: utf-8 -*-

import linuxcnc
import time
import sys
import os

# --- log fajl ---

log_file_path = '/tmp/py_m6.log'
os.makedirs(os.path.dirname(log_file_path), exist_ok=True)
sys.stdout = open(log_file_path, 'a')
sys.stderr = sys.stdout

class RackToolChange:
def **init**(self):
self.cnc = linuxcnc.command()
self.stat = linuxcnc.stat()
try:
self.tool_prepared = int(self.stat.tool)
except:
self.tool_prepared = 0
print(f"[INIT] Trenutno pripremljen alat: {self.tool_prepared}")

```
def dout(self, pin, state):
    self.cnc.set_digital_output(pin, 1 if state else 0)
    print(f"[DOUT] pin {pin} -> {'ON' if state else 'OFF'}")

def sleep(self, t):
    print(f"[SLEEP] {t} sekundi")
    time.sleep(t)

# PROLOG se poziva pre M6
def prolog(self, **words):
    tool = int(words.get('_selected_tool', 0))
    print(f"[PROLOG] priprema alata {tool}")
    self.dout(0, 1)   # LOCK
    self.dout(1, 1)   # CLAMP
    self.sleep(0.5)
    return 0

# EPILOG se poziva posle M6
def epilog(self, **words):
    tool = int(words.get('_selected_tool', 0))
    print(f"[EPILOG] zavrsio M6 za alat {tool}")
    self.dout(1, 0)
    self.dout(0, 0)
    self.sleep(0.2)
    return 0
```

# globalno dostupno za REMAP

rt = RackToolChange()

def prolog(**words):
return rt.prolog(**words)

def epilog(**words):
return rt.epilog(**words)