#!/usr/bin/python3

import gi
gi.require_version("Gtk", "3.0")
gi.require_version("Gdk", "3.0")
from gi.repository import Gtk, Gdk
from pygame import mixer

class PyApp:
  def __init__(self):
    mixer.init()
    self.sounds = {
      "buttonPress": mixer.Sound("sounds/button_press.wav"),
      "buttonRelease": mixer.Sound("sounds/button_release.wav"),
      "toggleEnablePress": mixer.Sound("sounds/toggle_enable_press.wav"),
      "toggleEnableRelease": mixer.Sound("sounds/toggle_enable_release.wav"),
      "toggleDisablePress": mixer.Sound("sounds/toggle_disable_press.wav"),
      "toggleDisableRelease": mixer.Sound("sounds/toggle_disable_release.wav"),
      "spinChangeUp": mixer.Sound("sounds/spin_change_up.wav"),
      "spinChangeDn": mixer.Sound("sounds/spin_change_dn.wav"),
      "eStop": mixer.Sound("sounds/estop.wav"),
      "eStart": mixer.Sound("sounds/estart.wav"),
    }
    self.spin_values = {}

    super(PyApp, self).__init__()

    self.builder = Gtk.Builder()
    self.builder.add_from_file("test.glade")

    handlers = {
        "onDestroy": self.onExit,
        "onButtonPress": self.onButtonPress,
        "onButtonRelease": self.onButtonRelease,
        "onButtonClick": self.onButtonClick,
        "onTogglePress": self.onTogglePress,
        "onToggleRelease": self.onToggleRelease,
        "onSpinOutput": self.onSpinOutput,
        "onSpinChange": self.onSpinChange,
        "onJogModeChange": self.onJogModeChange,
        "onEstopPress": self.onEstopPress
    }
    self.builder.connect_signals(handlers)

    self.screen = Gdk.Screen.get_default()

    self.provider = Gtk.CssProvider()
    self.provider.load_from_path("test.css")

    Gtk.StyleContext.add_provider_for_screen(self.screen, self.provider, Gtk.STYLE_PROVIDER_PRIORITY_APPLICATION)

    self.window = self.builder.get_object("window1")
    self.window.show_all()

  def onEstopPress(self, button, *args):
    self.sounds["eStart"].play() if button.get_active() else self.sounds["eStop"].play()

  def onButtonPress(self, button, *args):
    if self.sounds["buttonPress"].get_num_channels() == 0:
      self.sounds["buttonPress"].play()

  def onButtonRelease(self, button, *args):
    if self.sounds["buttonRelease"].get_num_channels() == 0:
      self.sounds["buttonRelease"].play()

  def onTogglePress(self, button, *args):
    self.sounds["toggleDisablePress"].play() if button.get_active() else self.sounds["toggleEnablePress"].play()

  def onToggleRelease(self, button, *args):
    self.sounds["toggleDisableRelease"].play() if button.get_active() else self.sounds["toggleEnableRelease"].play()

  def onButtonClick(self, button):
    self.provider.load_from_path("test.css")
    # Gtk.main_quit()

  def onSpinOutput(self, spinbutton):
    adjustment = spinbutton.get_adjustment()
    name  = Gtk.Buildable.get_name(spinbutton)
    value = adjustment.get_value()
    cache = self.spin_values.get(name, 100)
    self.sounds["spinChangeUp"].play() if(cache < value) else self.sounds["spinChangeDn"].play()
    self.spin_values[Gtk.Buildable.get_name(spinbutton)] = value
    if name == "jog_rate_step": 
      spinbutton.set_text(str(value))
    else:
      spinbutton.set_text(str(int(value)) + "%")
    return True

  def onSpinChange(self, spinbutton):
    pass

  def onJogModeChange(self, radiobutton): 
    self.builder.get_object("jog_rate_cont").hide()
    self.builder.get_object("jog_rate_step").hide()
    if radiobutton.get_active():
      self.builder.get_object("jog_rate_" + radiobutton.get_label().lower()).show()

  # def onSkinSwitch(self, button):
  #   self.window.get_style_context().remove_class("battered") if button.get_active() else self.window.get_style_context().add_class("battered")

  def onExit(self, window): 
    mixer.quit()
    Gtk.main_quit

if __name__ == "__main__":
  app = PyApp()
  Gtk.main()