#!/usr/bin/python

import atexit
import time
import hal

fname = "/home/digital4/linuxcnc/configs/Digital_4w/tmp/timelog.txt"
delta_t = .1 # seconds poll interval, hold inputs at least this long

f = open(fname,"a") # a: append if file exists 

def final_message():
    t_end = time.time()
    msg = ("\nEnd: %s Time since start: %f\n" %(time.ctime(),t_end - t_begin))
    f.write(msg)
    f.flush()
    f.close()
atexit.register(final_message)

h = hal.component("timelog")
h.newpin("start",hal.HAL_BIT,hal.HAL_IN)
h.newpin("pwron",hal.HAL_BIT,hal.HAL_IN)
h.ready()

old_pwron_pin_value = False
old_start_pin_value = False

t_begin = time.time()
msg = ("\n\nBegin %s\n\n" % time.ctime())
f.write(msg)
f.flush()

poweron = False
while True:
    time.sleep(delta_t)
    pwron_pin_value = h["pwron"]
    if pwron_pin_value and not old_pwron_pin_value:
        if poweron:
            msg = ("Power Off: %s Elapsed: %f\n" % (time.ctime(),t_now - t_on))
            f.write(msg)
            f.flush()
        else:
            poweron = True
            t_now = time.time()
            msg = ("Power On: %s" %time.ctime())
            f.write(msg)
            f.flush()
            t_on = time.time()
            started = False
            while True:
                start_pin_value = h["start"]
                if start_pin_value and not old_start_pin_value:
                    if started:
                        msg = ("     Stop:  %s     Elapsed: %f\n" % (time.ctime(),t_now - t_start))
                        f.write(msg)
                        f.flush()
                    else:
                        started = True
                        msg = ("Start: %s" %time.ctime())
                        f.write(msg)
                        f.flush()
                        t_start = time.time()
                old_start_pin_value = start_pin_value
    old_pwron_pin_value = pwron_pin_value



    

