#!/usr/bin/python

import atexit
import time
import hal

fname = "/home/digital4/linuxcnc/configs/Digital_4w/tmp/timelog.txt"
delta_t = .1 # seconds poll interval, hold inputs at least this long

f = open(fname,"a") # a: append if file exists 

def final_message():
    t_end = time.time()
    msg = ("\n\nEnd: %s Time since start: %f\n" %(time.ctime(),t_end - t_begin))
    f.write(msg)
    f.flush()
    f.close()
atexit.register(final_message)

h = hal.component("timelog")
h.newpin("start",hal.HAL_BIT,hal.HAL_IN)
h.newpin("stop",hal.HAL_BIT,hal.HAL_IN)
h.ready()

old_start_pin_value = False
old_stop_pin_value  = False
t_begin = time.time()
msg = ("Begin %s\n\n" % time.ctime())
f.write(msg)
f.flush()
started = False
while True:
    time.sleep(delta_t)
    start_pin_value = h["start"]
    if start_pin_value and not old_start_pin_value:
        if started:
            msg = ("UNEXPECTED: received start while waiting for stop\n")
            f.write(msg)
            f.flush()
        else:
            started = True
            msg = ("Start: %s\n" %time.ctime())
            f.write(msg)
            f.flush()
            t_start = time.time()
    old_start_pin_value = start_pin_value

    stop_pin_value = h["stop"]
    if stop_pin_value and not old_stop_pin_value:
        if not started:
            msg = ("UNEXPECTED: received stop while waiting for start\n")
            f.write(msg)
            f.flush()
        else:
            started = False
            t_now = time.time()
            msg = ("     Stop:  %s Elapsed: %f\n\n" % (time.ctime(),t_now - t_start))
            f.write(msg)
            f.flush()
    old_stop_pin_value = stop_pin_value

