#!/bin/bash
# LinuxCNC Tool Manager Auto-Launch Script
# This script is called by LinuxCNC on startup to launch the tool manager

# Wait for LinuxCNC to fully start (give db_tool time to launch)
sleep 2

# Find the tool database file
# Priority: 1) Command line arg, 2) Active db_tool instance, 3) Default location
DB_FILE=""

if [ -n "$1" ]; then
    # Database file provided as argument
    DB_FILE="$1"
else
    # Try to detect from running db_tool process
    DB_PID=$(pgrep -x db_tool)
    if [ -n "$DB_PID" ]; then
        # Extract database file from command line
        DB_FILE=$(tr '\0' ' ' < /proc/$DB_PID/cmdline | grep -oP '[\w/.-]+\.dat' | head -1)
    fi

    # Fallback to default location
    if [ -z "$DB_FILE" ] || [ ! -f "$DB_FILE" ]; then
        DB_FILE="$HOME/linuxcnc_tool_data/tool_usage.dat"
    fi
fi

# Launch tool manager in background
if [ -f "$DB_FILE" ]; then
    # Check if already running to avoid duplicates
    if ! pgrep -f "db_tool_manager.*$DB_FILE" > /dev/null; then
        /usr/local/bin/db_tool_manager "$DB_FILE" &
        echo "Launched db_tool_manager with database: $DB_FILE"
    else
        echo "db_tool_manager already running for $DB_FILE"
    fi
else
    echo "Warning: Tool database not found: $DB_FILE"
    # Launch anyway - it will show error dialog
    /usr/local/bin/db_tool_manager &
fi
